<?php
/**
 * Simple API test endpoint - bypasses auto-prepend.php completely
 * Place this in /docker/whp/web/ to test if API authentication works
 */

// Load WHP configuration and database
require_once '/docker/whp/web/configs/config.php';
require_once '/docker/whp/web/libs/mysqlmgmt.php';
require_once '/docker/whp/web/libs/ApiKeyManager.php';

// Set JSON response headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key, X-API-Secret, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

try {
    // Get API credentials from headers
    $apiKey = $_SERVER['HTTP_X_API_KEY'] ?? '';
    $apiSecret = $_SERVER['HTTP_X_API_SECRET'] ?? '';
    $ipAddress = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    
    echo json_encode([
        'debug' => [
            'api_key_received' => !empty($apiKey) ? 'YES' : 'NO',
            'api_secret_received' => !empty($apiSecret) ? 'YES' : 'NO',
            'api_key_prefix' => substr($apiKey, 0, 10) . '...',
            'request_method' => $_SERVER['REQUEST_METHOD'],
            'request_uri' => $_SERVER['REQUEST_URI'],
            'remote_addr' => $ipAddress
        ]
    ]);
    
    if (empty($apiKey) || empty($apiSecret)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing API credentials',
            'debug' => 'API key or secret not provided in headers'
        ]);
        exit;
    }
    
    // Connect to database
    $MySQLMgmt = new mysqlmgmt();
    $db = $MySQLMgmt->getMySQLConnection();
    $db->exec("USE whp");
    
    // Test API key validation
    $apiManager = new ApiKeyManager($db);
    $result = $apiManager->validateApiKey($apiKey, $apiSecret, $ipAddress);
    
    if ($result['success']) {
        echo json_encode([
            'status' => 'success',
            'message' => 'API authentication successful',
            'data' => [
                'api_key_valid' => true,
                'timestamp' => date('c')
            ]
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'API authentication failed',
            'error' => $result['error'],
            'debug' => 'Check API key and secret'
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error',
        'error' => $e->getMessage()
    ]);
}
?>