<?php
/**
 * Debug headers to see what the API authentication is receiving
 */

header('Content-Type: application/json');

echo json_encode([
    'debug_info' => [
        'getallheaders_exists' => function_exists('getallheaders'),
        'server_headers' => [
            'HTTP_X_API_KEY' => $_SERVER['HTTP_X_API_KEY'] ?? 'NOT_SET',
            'HTTP_X_API_SECRET' => $_SERVER['HTTP_X_API_SECRET'] ?? 'NOT_SET'
        ],
        'getallheaders_result' => function_exists('getallheaders') ? getallheaders() : 'FUNCTION_NOT_AVAILABLE',
        'raw_headers' => array_filter($_SERVER, function($key) {
            return strpos($key, 'HTTP_') === 0;
        }, ARRAY_FILTER_USE_KEY)
    ]
], JSON_PRETTY_PRINT);
?>