{*
 * WHP WHMCS Module - Client Area Overview Template
 *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fa fa-server"></i>
            Account Overview
        </h3>
    </div>
    <div class="panel-body">
        
        {if $user_info}
            <div class="row">
                <div class="col-md-6">
                    <h4>Account Information</h4>
                    <table class="table table-condensed">
                        <tr>
                            <td><strong>Username:</strong></td>
                            <td>{$user_info.username}</td>
                        </tr>
                        {if $user_info.uid}
                        <tr>
                            <td><strong>User ID:</strong></td>
                            <td>{$user_info.uid}</td>
                        </tr>
                        {/if}
                        {if $user_info.home_directory}
                        <tr>
                            <td><strong>Home Directory:</strong></td>
                            <td>{$user_info.home_directory}</td>
                        </tr>
                        {/if}
                    </table>
                </div>
                
                <div class="col-md-6">
                    <h4>Resource Limits</h4>
                    {if $user_info.resources}
                        <table class="table table-condensed">
                            <tr>
                                <td><strong>CPU Cores:</strong></td>
                                <td>{$user_info.resources.cpu_cores|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Memory:</strong></td>
                                <td>{$user_info.resources.memory_gb|default:'N/A'} GB</td>
                            </tr>
                            <tr>
                                <td><strong>Disk Space:</strong></td>
                                <td>{$user_info.resources.disk_gb|default:'N/A'} GB</td>
                            </tr>
                            <tr>
                                <td><strong>Domains:</strong></td>
                                <td>{$user_info.resources.domains|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Sites:</strong></td>
                                <td>{$user_info.resources.sites|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Email Accounts:</strong></td>
                                <td>{$user_info.resources.email_accounts|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Databases:</strong></td>
                                <td>{$user_info.resources.databases|default:'N/A'}</td>
                            </tr>
                        </table>
                    {else}
                        <p class="text-muted">Resource information not available</p>
                    {/if}
                </div>
            </div>
            
            {if $user_info.usage}
            <div class="row">
                <div class="col-md-12">
                    <h4>Current Usage</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="panel panel-info">
                                <div class="panel-body text-center">
                                    <h3>{$user_info.usage.disk_used_mb|default:'0'} MB</h3>
                                    <p>Disk Space Used</p>
                                    {if $user_info.resources.disk_gb}
                                        {assign var="disk_limit_mb" value=$user_info.resources.disk_gb*1024}
                                        {assign var="disk_used_mb" value=$user_info.usage.disk_used_mb|default:0}
                                        {assign var="disk_percent" value=($disk_used_mb/$disk_limit_mb)*100}
                                        <div class="progress">
                                            <div class="progress-bar {if $disk_percent > 80}progress-bar-danger{elseif $disk_percent > 60}progress-bar-warning{else}progress-bar-success{/if}" 
                                                 role="progressbar" style="width: {$disk_percent|number_format:1}%">
                                                {$disk_percent|number_format:1}%
                                            </div>
                                        </div>
                                        <small class="text-muted">of {$disk_limit_mb} MB limit</small>
                                    {/if}
                                </div>
                            </div>
                        </div>
                        
                        {if $server_stats.load_average}
                        <div class="col-md-4">
                            <div class="panel panel-info">
                                <div class="panel-body text-center">
                                    <h3>{$server_stats.load_average.1_minute|number_format:2}</h3>
                                    <p>Server Load (1 min)</p>
                                    <small class="text-muted">
                                        5min: {$server_stats.load_average.5_minutes|number_format:2}, 
                                        15min: {$server_stats.load_average.15_minutes|number_format:2}
                                    </small>
                                </div>
                            </div>
                        </div>
                        {/if}
                        
                        {if $server_stats.memory_usage}
                        <div class="col-md-4">
                            <div class="panel panel-info">
                                <div class="panel-body text-center">
                                    <h3>{$server_stats.memory_usage.usage_percentage|number_format:1}%</h3>
                                    <p>Server Memory Usage</p>
                                    <div class="progress">
                                        <div class="progress-bar {if $server_stats.memory_usage.usage_percentage > 80}progress-bar-danger{elseif $server_stats.memory_usage.usage_percentage > 60}progress-bar-warning{else}progress-bar-success{/if}" 
                                             role="progressbar" style="width: {$server_stats.memory_usage.usage_percentage}%">
                                        </div>
                                    </div>
                                    <small class="text-muted">
                                        {$server_stats.memory_usage.used_mb|number_format:0} MB / 
                                        {$server_stats.memory_usage.total_mb|number_format:0} MB
                                    </small>
                                </div>
                            </div>
                        </div>
                        {/if}
                    </div>
                    
                    {if $user_info.usage.last_updated}
                    <p class="text-muted text-right">
                        <small>Last updated: {$user_info.usage.last_updated}</small>
                    </p>
                    {/if}
                </div>
            </div>
            {/if}
            
            <div class="row">
                <div class="col-md-12">
                    <h4>Quick Actions</h4>
                    <div class="btn-group" role="group">
                        <a href="{$SYSTEMURL}clientarea.php?action=productdetails&id={$serviceid}&modop=custom&a=sso" 
                           class="btn btn-primary" target="_blank">
                            <i class="fa fa-sign-in"></i> Access Control Panel
                        </a>
                        
                        {if $user_info.resources.api_enabled}
                        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#apiInfoModal">
                            <i class="fa fa-code"></i> API Information
                        </button>
                        {/if}
                    </div>
                </div>
            </div>
            
        {else}
            <div class="alert alert-warning">
                <i class="fa fa-exclamation-triangle"></i>
                Unable to retrieve account information at this time. Please try again later.
            </div>
        {/if}
        
    </div>
</div>

{if $server_stats}
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fa fa-bar-chart"></i>
            Server Statistics
        </h3>
    </div>
    <div class="panel-body">
        <div class="row">
            {if $server_stats.uptime}
            <div class="col-md-3">
                <div class="text-center">
                    <h4>{$server_stats.uptime.days}</h4>
                    <p class="text-muted">Days Uptime</p>
                </div>
            </div>
            {/if}
            
            {if $server_stats.user_count}
            <div class="col-md-3">
                <div class="text-center">
                    <h4>{$server_stats.user_count}</h4>
                    <p class="text-muted">Total Users</p>
                </div>
            </div>
            {/if}
            
            {if $server_stats.docker_stats}
            <div class="col-md-3">
                <div class="text-center">
                    <h4>{$server_stats.docker_stats.running_containers}</h4>
                    <p class="text-muted">Active Containers</p>
                </div>
            </div>
            {/if}
            
            {if $server_stats.disk_usage.root_filesystem}
            <div class="col-md-3">
                <div class="text-center">
                    <h4>{$server_stats.disk_usage.root_filesystem.usage_percentage|number_format:1}%</h4>
                    <p class="text-muted">Server Disk Usage</p>
                </div>
            </div>
            {/if}
        </div>
    </div>
</div>
{/if}

{* API Information Modal *}
{if $user_info.resources.api_enabled}
<div class="modal fade" id="apiInfoModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">API Access Information</h4>
            </div>
            <div class="modal-body">
                <p>Your account has API access enabled with the following settings:</p>
                <table class="table table-condensed">
                    <tr>
                        <td><strong>API Enabled:</strong></td>
                        <td><span class="label label-success">Yes</span></td>
                    </tr>
                    <tr>
                        <td><strong>Rate Limit:</strong></td>
                        <td>{$user_info.resources.api_rate_limit|default:'100'} requests per hour</td>
                    </tr>
                </table>
                
                <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i>
                    <strong>Note:</strong> To obtain API credentials and documentation, please log into your control panel.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <a href="{$SYSTEMURL}clientarea.php?action=productdetails&id={$serviceid}&modop=custom&a=sso" 
                   class="btn btn-primary" target="_blank">Access Control Panel</a>
            </div>
        </div>
    </div>
</div>
{/if}

<style>
.progress {
    height: 6px;
    margin-bottom: 5px;
}

.panel .table {
    margin-bottom: 0;
}

.btn-group {
    margin-bottom: 15px;
}

.modal-dialog {
    margin-top: 100px;
}
</style>