<?php
// Permission checking is now handled by the permission system in auto-prepend.php

require_once('/docker/whp/web/libs/security_manager.php');
$SecManager = new security_manager();

$message = '';
$message_type = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'unblock_ip':
                if (!empty($_POST['ip_address'])) {
                    $result = $SecManager->unblock_ip($_POST['ip_address']);
                    if ($result) {
                        $message = 'IP address unblocked successfully: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error unblocking IP address';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'block_ip':
                if (!empty($_POST['ip_address'])) {
                    $reason = !empty($_POST['reason']) ? $_POST['reason'] : 'Manual block';
                    $result = $SecManager->block_ip($_POST['ip_address'], $reason);
                    if ($result) {
                        $message = 'IP address blocked successfully: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error blocking IP address (may be whitelisted)';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'add_whitelist':
                if (!empty($_POST['ip_address'])) {
                    $description = !empty($_POST['description']) ? $_POST['description'] : '';
                    $result = $SecManager->add_whitelist_ip($_POST['ip_address'], $description);
                    if ($result) {
                        $message = 'IP address added to whitelist: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error adding IP to whitelist';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'remove_whitelist':
                if (!empty($_POST['ip_address'])) {
                    $result = $SecManager->remove_whitelist_ip($_POST['ip_address']);
                    if ($result) {
                        $message = 'IP address removed from whitelist: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error removing IP from whitelist';
                        $message_type = 'danger';
                    }
                }
                break;
        }
    }
}

// Get data
$blocked_ips = $SecManager->get_blocked_ips();
$whitelist_ips = $SecManager->get_whitelist_ips();
$security_stats = $SecManager->get_security_stats();

// Get access statistics
require_once('/docker/whp/web/libs/permission_manager.php');
$PermManager = new permission_manager();
$access_stats = $PermManager->get_system_access_stats(30);
?>
<?php if (!empty($message)): ?>
<div class="row">
    <div class="col-sm-12">
        <div class="alert alert-<?php echo $message_type; ?> alert-dismissible" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <?php echo htmlspecialchars($message); ?>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- Security Statistics -->
<div class="row g-4 mb-4">
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Blocked IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $security_stats['blocked_ips']; ?></h2>
                <p class="mb-0">Currently blocked IP addresses</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Failed Attempts (24h)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-warning"><?php echo $security_stats['failed_attempts_24h']; ?></h2>
                <p class="mb-0">Failed login attempts in last 24 hours</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Whitelisted IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-success"><?php echo $security_stats['whitelist_ips']; ?></h2>
                <p class="mb-0">IP addresses in whitelist</p>
            </div>
        </div>
    </div>
</div>

<!-- Access Statistics -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Total Access Attempts (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-info"><?php echo $access_stats['total_attempts']; ?></h2>
                <p class="mb-0">Total page/API access attempts</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Denied Access (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $access_stats['denied_attempts']; ?></h2>
                <p class="mb-0">Permission denied attempts</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Success Rate (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-success"><?php echo $access_stats['success_rate']; ?>%</h2>
                <p class="mb-0">Successful access rate</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Top Denied Page</h5>
            </div>
            <div class="card-body text-center">
                <?php if (!empty($access_stats['top_denied_pages'])): ?>
                <h2 class="text-warning"><?php echo htmlspecialchars($access_stats['top_denied_pages'][0]['page']); ?></h2>
                <p class="mb-0"><?php echo $access_stats['top_denied_pages'][0]['count']; ?> denials</p>
                <?php else: ?>
                <h2 class="text-muted">-</h2>
                <p class="mb-0">No denials</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<div class="row g-4 mb-4">
    <!-- Block IP Panel -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Block IP Address</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="block_ip">
                    <div class="mb-3">
                        <label for="block_ip" class="form-label">IP Address</label>
                        <input type="text" class="form-control" id="block_ip" name="ip_address" placeholder="192.168.1.100" required>
                    </div>
                    <div class="mb-3">
                        <label for="block_reason" class="form-label">Reason (optional)</label>
                        <input type="text" class="form-control" id="block_reason" name="reason" placeholder="Manual block">
                    </div>
                    <button type="submit" class="btn btn-danger">Block IP</button>
                </form>
            </div>
        </div>
    </div>
    <!-- Add to Whitelist Panel -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Add to Whitelist</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="add_whitelist">
                    <div class="mb-3">
                        <label for="whitelist_ip" class="form-label">IP Address</label>
                        <input type="text" class="form-control" id="whitelist_ip" name="ip_address" placeholder="192.168.1.100" required>
                    </div>
                    <div class="mb-3">
                        <label for="whitelist_description" class="form-label">Description (optional)</label>
                        <input type="text" class="form-control" id="whitelist_description" name="description" placeholder="Office, Home, etc.">
                    </div>
                    <button type="submit" class="btn btn-success">Add to Whitelist</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row g-4">
    <!-- Blocked IPs Table -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Blocked IPs</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr><th>IP Address</th><th width="120">Action</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($blocked_ips as $ip): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($ip); ?></td>
                                <td>
                                    <form method="POST" action="" style="display:inline;">
                                        <input type="hidden" name="action" value="unblock_ip">
                                        <input type="hidden" name="ip_address" value="<?php echo htmlspecialchars($ip); ?>">
                                        <button type="submit" class="btn btn-warning btn-sm">Unblock</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Whitelist Table -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Whitelisted IPs</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr><th>IP Address</th><th>Description</th><th width="120">Action</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($whitelist_ips as $ip): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($ip['ip_address']); ?></td>
                                <td><?php echo htmlspecialchars($ip['description']); ?></td>
                                <td>
                                    <form method="POST" action="" style="display:inline;">
                                        <input type="hidden" name="action" value="remove_whitelist">
                                        <input type="hidden" name="ip_address" value="<?php echo htmlspecialchars($ip['ip_address']); ?>">
                                        <button type="submit" class="btn btn-danger btn-sm">Remove</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div> 