-- Email Import Feature Update
-- Date: 2025-07-23
-- Description: Add email import functionality for root users to import existing email accounts from mail server

USE whp;

-- No database schema changes required for this feature
-- The feature uses existing email_accounts, email_forwarders, and domains tables

-- Add a comment to track this feature
-- This is a documentation-only migration
SELECT 'Email import feature added - allows root users to import existing email accounts from mail server' AS feature_update;

-- Feature summary:
-- 1. Added getEmailAccounts() method to MailServerClient to fetch accounts from mail server API
-- 2. Added importEmailAccountsFromMailServer() method to emailmgmt class
-- 3. Added import UI section in email-management.php for root users
-- 4. Validates domains exist on server before allowing import
-- 5. Imports both email accounts and forwarders
-- 6. Skips existing accounts and assigns temporary passwords to imported accounts