<?php
// Permission checking is now handled by the permission system in auto-prepend.php

require_once('/docker/whp/web/libs/usermgmt.php');
$UserMgmt = new usermgmt();

$message = '';
$message_type = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_user':
                if (!empty($_POST['username']) && !empty($_POST['password'])) {
                    $result = $UserMgmt->create_new_user($_POST['username'], $_POST['password']);
                    if ($result['status'] === '0') {
                        // Set default disk quota for new user (1000 MB)
                        $quota_cmd = '/root/whp/scripts/quota-helper.sh set ' . escapeshellarg($_POST['username']) . ' 1000 2>&1';
                        $quota_output = shell_exec($quota_cmd);
                        $quota_exit_code = 0;
                        exec('/root/whp/scripts/quota-helper.sh set ' . escapeshellarg($_POST['username']) . ' 1000', $quota_exec_output, $quota_exit_code);
                        
                        $message = 'User created successfully: ' . $_POST['username'];
                        if ($quota_exit_code === 0) {
                            $message .= ' (Disk quota set to 1000 MB)';
                        } else {
                            $message .= ' (Warning: Disk quota not set - ' . trim($quota_output) . ')';
                            error_log("Failed to set quota for {$_POST['username']} (exit code: $quota_exit_code): " . trim($quota_output));
                        }
                        $message_type = 'success';
                    } else {
                        $message = 'Error creating user: ' . $result['msg'];
                        $message_type = 'danger';
                    }
                } else {
                    $message = 'Username and password are required';
                    $message_type = 'danger';
                }
                break;
                
            case 'delete_user':
                if (!empty($_POST['username'])) {
                    $result = $UserMgmt->delete_user($_POST['username']);
                    if ($result['status'] === '0') {
                        // Remove disk quota for deleted user
                        $quota_cmd = '/root/whp/scripts/quota-helper.sh remove ' . escapeshellarg($_POST['username']) . ' 2>&1';
                        $quota_output = shell_exec($quota_cmd);
                        $quota_exit_code = 0;
                        exec('/root/whp/scripts/quota-helper.sh remove ' . escapeshellarg($_POST['username']), $quota_exec_output, $quota_exit_code);
                        
                        $message = 'User deleted successfully: ' . $_POST['username'];
                        if ($quota_exit_code === 0) {
                            $message .= ' (Disk quota removed)';
                        } else {
                            $message .= ' (Warning: Disk quota not removed - ' . trim($quota_output) . ')';
                            error_log("Failed to remove quota for {$_POST['username']} (exit code: $quota_exit_code): " . trim($quota_output));
                        }
                        $message_type = 'success';
                    } else {
                        $message = 'Error deleting user: ' . $result['msg'];
                        $message_type = 'danger';
                    }
                } else {
                    $message = 'Username is required';
                    $message_type = 'danger';
                }
                break;
                
            case 'change_password':
                if (!empty($_POST['username']) && !empty($_POST['password'])) {
                    $result = $UserMgmt->change_password($_POST['username'], $_POST['password']);
                    if ($result['status'] === '0') {
                        $message = 'Password changed successfully for: ' . $_POST['username'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error changing password: ' . $result['msg'];
                        $message_type = 'danger';
                    }
                } else {
                    $message = 'Username and password are required';
                    $message_type = 'danger';
                }
                break;
        }
    }
}

// Get list of users
$users = $UserMgmt->list_users();
?>

<?php if (!empty($message)): ?>
<div class="row">
    <div class="col-sm-12">
        <div class="alert alert-<?php echo $message_type; ?> alert-dismissible" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <?php echo htmlspecialchars($message); ?>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="row">
    <!-- Create User Panel -->
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Create New User</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="create_user">
                    <div class="mb-3">
                        <label for="create_username" class="form-label">Username</label>
                        <input type="text" class="form-control" id="create_username" name="username" placeholder="newuser" required>
                    </div>
                    <div class="mb-3">
                        <label for="create_password" class="form-label">Password</label>
                        <input type="password" class="form-control" id="create_password" name="password" placeholder="Secure password" required>
                    </div>
                    <button type="submit" class="btn btn-success">Create User</button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Change Password Panel -->
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Change User Password</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="change_password">
                    <div class="mb-3">
                        <label for="change_username" class="form-label">Username</label>
                        <select class="form-select" id="change_username" name="username" required>
                            <option value="">Select user...</option>
                            <?php foreach ($users as $user): ?>
                            <option value="<?php echo htmlspecialchars($user['username']); ?>"><?php echo htmlspecialchars($user['username']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="change_password" class="form-label">New Password</label>
                        <input type="password" class="form-control" id="change_password" name="password" placeholder="New password" required>
                    </div>
                    <button type="submit" class="btn btn-warning">Change Password</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Users List -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">System Users</h5>
            </div>
            <div class="card-body">
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Username</th>
                            <th>UID</th>
                            <th>Home Directory</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['uid']); ?></td>
                            <td><?php echo htmlspecialchars($user['home']); ?></td>
                            <td>
                                <?php if ($user['username'] !== 'root' && $user['username'] !== 'nobody' && $user['uid'] >= 1001): ?>
                                <form method="POST" action="" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete user <?php echo htmlspecialchars($user['username']); ?>? This action cannot be undone.');">
                                    <input type="hidden" name="action" value="delete_user">
                                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['username']); ?>">
                                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                </form>
                                <?php else: ?>
                                <span class="text-muted">Protected</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div> 