-- ================================================
-- WordPress Backup Target Preference Update
-- Date: 2025-01-19
-- Description: Add user preference for default backup target in WordPress operations
-- ================================================

USE whp;

-- Add preferred backup target to wordpress_sites table
ALTER TABLE wordpress_sites 
ADD COLUMN preferred_backup_target_id INT DEFAULT NULL AFTER auto_backup_before_update,
ADD CONSTRAINT fk_wordpress_backup_target 
    FOREIGN KEY (preferred_backup_target_id) 
    REFERENCES backup_targets(id) 
    ON DELETE SET NULL;

-- Add index for faster lookups
CREATE INDEX idx_backup_target ON wordpress_sites(preferred_backup_target_id);

-- Rollback procedure
DELIMITER //
CREATE PROCEDURE IF NOT EXISTS rollback_wordpress_backup_target()
BEGIN
    -- Remove foreign key constraint
    ALTER TABLE wordpress_sites DROP FOREIGN KEY fk_wordpress_backup_target;
    
    -- Drop index
    DROP INDEX idx_backup_target ON wordpress_sites;
    
    -- Drop column
    ALTER TABLE wordpress_sites DROP COLUMN preferred_backup_target_id;
END//
DELIMITER ;

-- Execute: CALL rollback_wordpress_backup_target(); to rollback