-- Fix backup scheduler for WordPress sites and db_name column issue
-- Date: 2025-07-22
-- Issues fixed:
-- 1. BackupEngine was using 'db_name' instead of 'database_name' column
-- 2. Backup scheduler now detects WordPress sites and creates proper WordPress backups
-- 3. When resource_name is NULL, scheduler auto-selects first available resource

USE whp;

-- Update the comment to clarify backup handling for WordPress sites
ALTER TABLE backup_schedules 
MODIFY COLUMN backup_type ENUM('site', 'userfiles', 'database', 'all') NOT NULL 
COMMENT 'Backup type - site type auto-detects WordPress sites for combined backup';

-- Note: system_log table doesn't exist in current schema
-- Fixes applied:
-- 1. Fixed BackupEngine to use correct database_name column for WordPress backups
-- 2. Enhanced backup scheduler to auto-detect WordPress sites and create combined backups  
-- 3. Fixed backup scheduler to auto-select first resource when resource_name is NULL