<?php
// Set content type to JSON
header('Content-Type: application/json');

// Check API permission
check_api_permission('user-management');

require_once('/docker/whp/web/libs/usermgmt.php');
$UserMgmt = new usermgmt();

// Get request method and action
$method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Handle different HTTP methods and actions
switch ($method) {
    case 'GET':
        if ($action === 'list') {
            // List all users
            $users = $UserMgmt->list_users();
            echo json_encode(array(
                'status' => 'success',
                'data' => $users
            ));
        } else {
            http_response_code(400);
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Invalid action. Use ?action=list to list users.'
            ));
        }
        break;
        
    case 'POST':
        // Get JSON input
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            http_response_code(400);
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Invalid JSON input'
            ));
            break;
        }
        
        switch ($action) {
            case 'create':
                if (empty($input['username']) || empty($input['password'])) {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Username and password are required'
                    ));
                    break;
                }
                
                $result = $UserMgmt->create_new_user($input['username'], $input['password']);
                if ($result['status'] === '0') {
                    echo json_encode(array(
                        'status' => 'success',
                        'message' => 'User created successfully',
                        'data' => array(
                            'username' => $input['username'],
                            'uid' => $result['uid']
                        )
                    ));
                } else {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => $result['msg']
                    ));
                }
                break;
                
            case 'delete':
                if (empty($input['username'])) {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Username is required'
                    ));
                    break;
                }
                
                $result = $UserMgmt->delete_user($input['username']);
                if ($result['status'] === '0') {
                    echo json_encode(array(
                        'status' => 'success',
                        'message' => 'User deleted successfully',
                        'data' => array(
                            'username' => $input['username']
                        )
                    ));
                } else {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => $result['msg']
                    ));
                }
                break;
                
            case 'change_password':
                if (empty($input['username']) || empty($input['password'])) {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => 'Username and password are required'
                    ));
                    break;
                }
                
                $result = $UserMgmt->change_password($input['username'], $input['password']);
                if ($result['status'] === '0') {
                    echo json_encode(array(
                        'status' => 'success',
                        'message' => 'Password changed successfully',
                        'data' => array(
                            'username' => $input['username']
                        )
                    ));
                } else {
                    http_response_code(400);
                    echo json_encode(array(
                        'status' => 'error',
                        'message' => $result['msg']
                    ));
                }
                break;
                
            default:
                http_response_code(400);
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Invalid action. Use create, delete, or change_password.'
                ));
                break;
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(array(
            'status' => 'error',
            'message' => 'Method not allowed. Use GET or POST.'
        ));
        break;
}
?> 